/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcinterface1201.PacketEntityCSHandshakeClient;
import mcinterface1201.PacketEntityCSHandshakeServer;
import mcinterface1201.WrapperNBT;
import mcinterface1201.WrapperPlayer;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IInterfacePacket;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketBase;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

class InterfacePacket
implements IInterfacePacket {
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("mts", "main"), () -> "1", "1"::equals, "1"::equals);
    private static final BiMap<Byte, Class<? extends APacketBase>> packetMappings = HashBiMap.create();

    InterfacePacket() {
    }

    public static void init() {
        byte packetIndex;
        network.registerMessage(0, WrapperPacket.class, WrapperPacket::toBytes, WrapperPacket::fromBytes, WrapperPacket::handle);
        byte by = packetIndex = 0;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by, PacketEntityCSHandshakeClient.class);
        byte by2 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by2, PacketEntityCSHandshakeServer.class);
        APacketBase.initPackets(packetIndex);
    }

    @Override
    public void registerPacket(byte packetIndex, Class<? extends APacketBase> packetClass) {
        packetMappings.put((Object)packetIndex, packetClass);
    }

    @Override
    public byte getPacketIndex(APacketBase packet) {
        return (Byte)packetMappings.inverse().get(packet.getClass());
    }

    @Override
    public void sendToServer(APacketBase packet) {
        network.sendToServer((Object)new WrapperPacket(packet));
    }

    @Override
    public void sendToAllClients(APacketBase packet) {
        network.send(PacketDistributor.ALL.noArg(), (Object)new WrapperPacket(packet));
    }

    @Override
    public void sendToPlayer(APacketBase packet, IWrapperPlayer player) {
        network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)((WrapperPlayer)player).player), (Object)new WrapperPacket(packet));
    }

    private static AWrapperWorld getServerWorld(Supplier<NetworkEvent.Context> ctx) {
        return WrapperWorld.getWrapperFor(ctx.get().getSender().m_9236_());
    }

    @Override
    public void writeDataToBuffer(IWrapperNBT data, ByteBuf buf) {
        ((FriendlyByteBuf)buf).m_130079_(((WrapperNBT)data).tag);
    }

    @Override
    public WrapperNBT readDataFromBuffer(ByteBuf buf) {
        return new WrapperNBT(((FriendlyByteBuf)buf).m_130260_());
    }

    public static class WrapperPacket {
        private APacketBase packet;

        public WrapperPacket() {
        }

        public WrapperPacket(APacketBase packet) {
            this.packet = packet;
        }

        public static WrapperPacket fromBytes(FriendlyByteBuf buf) {
            byte packetIndex = buf.readByte();
            try {
                Class packetClass = (Class)packetMappings.get((Object)packetIndex);
                return new WrapperPacket((APacketBase)packetClass.getConstructor(ByteBuf.class).newInstance(buf));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IndexOutOfBoundsException("Was asked to create packet of index " + packetIndex + " but we haven't registered that one yet!");
            }
        }

        public static void toBytes(WrapperPacket message, FriendlyByteBuf buf) {
            message.packet.writeToBuffer((ByteBuf)buf);
        }

        public static void handle(WrapperPacket message, Supplier<NetworkEvent.Context> ctx) {
            if (message.packet.runOnMainThread()) {
                ctx.get().enqueueWork(() -> {
                    AWrapperWorld world = ((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER ? InterfacePacket.getServerWorld(ctx) : InterfaceManager.clientInterface.getClientWorld();
                    if (world != null) {
                        message.packet.handle(world);
                    }
                });
            } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                message.packet.handle(InterfacePacket.getServerWorld(ctx));
            } else {
                message.packet.handle(InterfaceManager.clientInterface.getClientWorld());
            }
            ctx.get().setPacketHandled(true);
        }
    }
}

